USE [Elerium]
GO

/****** Object:  StoredProcedure [dbo].[RP_GetRewardPointTransactionsWithMissingDays]    Script Date: 8/27/2013 2:31:20 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:		<James Davis>
-- Create date: <2013-07-30>
-- Description:	<returns list of records for a user>
-- =============================================
CREATE PROCEDURE [dbo].[RP_GetRewardPointTransactionsWithMissingDays]
	-- Add the parameters for the stored procedure here
	@userID int
	
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	declare @startDate datetime
	declare @endDate datetime

    set @startDate = (select min(datecreated) from [dbo].[RewardTransaction] where userid = @userID)
	set @endDate = (select max(datecreated) from [dbo].[RewardTransaction] where userid = @userID)

	if object_id('tempdb..#tempCF108') is not null
    drop table #tempCF108

	CREATE TABLE #tempCF108(userid int, orderid int, transferuserid int, datecreated datetime, pointchange money, [type] int, dailybudgetid int);
	insert into #tempCF108 (userid, orderid, transferuserid, datecreated, pointchange, [type], dailybudgetid)
	SELECT userid, orderid, transferuserid, dateadd(DAY,0, datediff(day,0, datecreated)) as datecreated, pointchange, [type], dailybudgetid 
	FROM [dbo].[RewardTransaction] as a
	where userid = @userid

	if object_id('tempdb..#tempCF109') is not null
		drop table #tempCF109

	CREATE TABLE #tempCF109(transdate datetime);
	insert into #tempCF109 (transdate)
	SELECT dateadd(DAY,0, datediff(day,0, calendardate)) as datecreated
	FROM [dbo].[RewardCalendar] as b
	where b.calendardate between @startDate and @endDate

	MERGE #tempCF108 as Target  
	USING #tempCF109 as source
	ON (Target.datecreated = source.transdate)
	When Matched then
	update set Target.datecreated = source.transdate
	WHEN NOT MATCHED THEN	
			INSERT (userid, orderid, transferuserid, datecreated, pointchange, [type], dailybudgetid)
			VALUES (@userid, NULL, NULL, source.transdate, 0.0, 0, NULL);

	select * from #tempCF108
	order by datecreated

	drop table #tempCF108
	drop table #tempCF109

END

GO


